/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.userprof;

import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class UserAttributes
implements Serializable {
    private static final String TRACE_MASKT = "XFRMUATT";
    private static final String TRACE_MASKF = "XFRMUATF";
    private static final String TRACE_MASKD = "XFRMUATD";
    private String userid;
    private byte[] password;
    private LocalizableText description;
    private boolean caseSensitive = false;
    private boolean rulesEnforced = false;
    private int expireDays = 0;
    private boolean multipleTaskRoles = true;
    private boolean multipleManagedResourceRoles = true;
    private ArrayList taskRoles = new ArrayList();
    private ArrayList managedResourceRoles = new ArrayList();
    private boolean editable = true;
    private boolean requiresPassword = true;
    private boolean remoteAccess = false;

    public UserAttributes(String userid, byte[] password, LocalizableText description) {
        this.userid = userid;
        this.password = password;
        this.description = description;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setPassword(byte[] password) {
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        this.password = password;
    }

    public byte[] getPassword() {
        Trace.trace(TRACE_MASKT, "<> getPassword()");
        return this.password;
    }

    public void setDescription(LocalizableText description) {
        this.description = description;
    }

    public LocalizableText getDescription() {
        if (this.description == null) {
            return new LocalizableText("");
        }
        return this.description;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isPasswordRulesEnforced() {
        return this.rulesEnforced;
    }

    public void setPasswordRulesEnforced(boolean rulesEnforced) {
        this.rulesEnforced = rulesEnforced;
    }

    public void setPasswordExpiration(int expireDays) {
        this.expireDays = expireDays;
    }

    public int getPasswordExpiration() {
        return this.expireDays;
    }

    public boolean isRemoteAccessPermitted() {
        return this.remoteAccess;
    }

    public void setRemoteAccess(boolean remoteAccess) {
        this.remoteAccess = remoteAccess;
    }

    public boolean allowMultipleTaskRoles() {
        return this.multipleTaskRoles;
    }

    public void setMultipleTaskRoles(boolean allowMultiple) {
        this.multipleTaskRoles = allowMultiple;
    }

    public boolean allowMultipleManagedResourceRoles() {
        return this.multipleManagedResourceRoles;
    }

    public void setMultipleManagedResourceRoles(boolean allowMultiple) {
        this.multipleManagedResourceRoles = allowMultiple;
    }

    public List getRoles(int type) {
        ArrayList roles = null;
        switch (type) {
            case 1: {
                roles = this.taskRoles;
                break;
            }
            case 0: {
                roles = this.managedResourceRoles;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid role type specified: " + type);
            }
        }
        return roles;
    }

    public void setRoles(int type, List roles) {
        switch (type) {
            case 1: {
                this.taskRoles = new ArrayList(roles);
                break;
            }
            case 0: {
                this.managedResourceRoles = new ArrayList(roles);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid role type specified: " + type);
            }
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setRequiresOldPassword(boolean oldRequired) {
        this.requiresPassword = oldRequired;
    }

    public boolean getRequiresOldPassword() {
        return this.requiresPassword;
    }
}

